; sse_integer.asm
extern printf

section .data
	
	dummy   db      13
align 16						
	pdivector1	dd 	1
                 	dd 	2
                 	dd 	3
                 	dd 	4
	pdivector2   	dd 	5
                 	dd 	6
                 	dd	7
                 	dd 	8
                 
        fmt1 db "Upakowany wektor całkowity 1: %d, %d, %d, %d",10,0
        fmt2 db "Upakowany wektor całkowity 2: %d, %d, %d, %d",10,0
        fmt3 db "Suma wektorów: %d, %d, %d, %d",10,0
        fmt4 db "Odwrotność sumy wektorów: %d, %d, %d, %d",10,0

section .bss
alignb 16
	pdivector_res 		resd 4
	pdivector_other 	resd 4

section .text							
	global main					
main:
push	rbp	
mov	rbp,rsp
    
; wypisujemy wektor 1
    mov	rsi,pdivector1
    mov 	rdi,fmt1
    call 	printpdi 
; wypisujemy wektor 2
    mov 	rsi,pdivector2
    mov 	rdi,fmt2
    call 	printpdi 

; dodajemy 2 wyrównane wektory całkowite
    movdqa	xmm0, [pdivector1]          
    paddd 	xmm0, [pdivector2] 
           
; zapisujemy wynik w pamięci
    movdqa 	[pdivector_res], xmm0
; wypisujemy wektor z pamięci
    mov 	rsi,pdivector_res
    mov 	rdi,fmt3
    call 	printpdi 
 
; kopiujemy wektor z pamięci do xmm3   
    movdqa xmm3,[pdivector_res]

; wyodrębniamy upakowane wartości z xmm3   
    pextrd eax, xmm3, 0
    pextrd ebx, xmm3, 1
    pextrd ecx, xmm3, 2
    pextrd edx, xmm3, 3
; wstawiamy je do xmm0 w odwrotnej kolejności   
    pinsrd xmm0, eax, 3
    pinsrd xmm0, ebx, 2
    pinsrd xmm0, ecx, 1
    pinsrd xmm0, edx, 0

; wypisujemy odwrócony wektor
    movdqa [pdivector_other], xmm0
    mov 	rsi,pdivector_other
    mov 	rdi,fmt4
    call 	printpdi   
    

; wyjście
mov 	rsp,rbp              
pop	rbp	
ret

; funkcja do wypisywania ---------------------------------------------
printpdi:    
push rbp
mov 	rbp,rsp
	movdqa xmm0, [rsi]
; wyodrębniamy upakowane wartości z xmm0
        pextrd esi, xmm0,0
        pextrd edx, xmm0,1
        pextrd ecx, xmm0,2
        pextrd r8d, xmm0,3
	mov	rax,0	; nie wypisujemy wartości zmiennoprzecinkowych
	call 	printf
leave
ret



